/*
 * Decompiled with CFR 0.152.
 */
package etstatistics;

import etstatistics.Statistic;
import etstatistics.WeaponStatistic;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETStatistics {
    private static final String[] WEAPONS = new String[]{"Knife", "Luger", "Colt", "MP-40", "Thompson", "K43 Rifle", "Garand", "Sten", "FG-42", "Grenade", "G.Launchr", "Landmine", "Satchel", "Panzer", "Mortar", "MG-42 Gun", "F.Thrower", "Airstrike", "Artillery", "Dynamite", "Syringe", "SmokeScrn"};
    public static final int WEAPON_COUNT = WEAPONS.length;
    private ArrayList<Statistic> stat = new ArrayList();
    private Statistic finalStat = null;
    private static final String PMAP = ">>> Map: ";
    private static final String PNICK = "Overall stats for: ";
    private static final String PDMGGIVE = "Damage Given: ";
    private static final String PTDMGGIVE = "Team Damage: ";
    private static final String PDMGRECV = "Damage Recvd: ";
    private static final String PTDMGRECV = "Team Damage Received: ";
    private static final String PGIB = "        Gibs: ";
    private static final String PRANK = "Rank: ";
    private static DecimalFormat df = new DecimalFormat("0.00");

    public static String getWeapon(int i) {
        return WEAPONS[i];
    }

    public boolean add(File file) throws IOException {
        BufferedReader bf = new BufferedReader(new FileReader(file));
        Statistic s = new Statistic();
        try {
            while (true) {
                int sub2;
                int sub;
                String data;
                if ((data = bf.readLine()) == null) {
                    return false;
                }
                if (data.length() == 0) continue;
                if (data.startsWith(PMAP)) {
                    s.map = data.substring(PMAP.length());
                    continue;
                }
                if (data.startsWith(PNICK)) {
                    sub = data.lastIndexOf("(");
                    sub2 = data.lastIndexOf(" Round");
                    s.playerName = data.substring(PNICK.length(), sub);
                    s.rounds = Integer.parseInt(data.substring(sub + 1, sub2));
                    continue;
                }
                if (data.indexOf(":") == 9) {
                    WeaponStatistic tempWS = new WeaponStatistic();
                    tempWS.weaponName = data.substring(0, 9).trim();
                    String temp = data.substring(17, 21).trim();
                    tempWS.hits = temp.length() > 0 ? Integer.parseInt(temp) : 0;
                    temp = data.substring(22, 26).trim();
                    tempWS.shots = temp.length() > 0 ? Integer.parseInt(temp) : 0;
                    temp = data.substring(27, 32).trim();
                    tempWS.kills = temp.length() > 0 ? Integer.parseInt(temp) : 0;
                    temp = data.substring(33, 39).trim();
                    tempWS.deaths = temp.length() > 0 ? Integer.parseInt(temp) : 0;
                    if (data.length() >= 40) {
                        temp = data.substring(40, 49).trim();
                        tempWS.headshots = Integer.parseInt(temp);
                    } else {
                        tempWS.headshots = 0;
                    }
                    s.weaponStats.add(tempWS);
                    s.kills += tempWS.kills;
                    s.deaths += tempWS.deaths;
                    s.eff = (double)s.kills / (double)s.deaths;
                    continue;
                }
                if (data.startsWith(PDMGGIVE)) {
                    sub = data.indexOf(PTDMGGIVE);
                    s.damageGiven = Integer.parseInt(data.substring(PDMGGIVE.length(), sub).trim());
                    s.teamDamageGiven = Integer.parseInt(data.substring(sub + PTDMGGIVE.length()).trim());
                    continue;
                }
                if (data.startsWith(PDMGRECV)) {
                    sub = data.indexOf(PTDMGRECV);
                    s.damageReceived = Integer.parseInt(data.substring(PDMGRECV.length(), sub).trim());
                    s.teamDamageReceived = Integer.parseInt(data.substring(sub + PTDMGRECV.length()).trim());
                    continue;
                }
                if (data.startsWith(PGIB)) {
                    s.gibs = Integer.parseInt(data.substring(PGIB.length()).trim());
                    continue;
                }
                if (data.startsWith(PRANK)) {
                    sub = data.lastIndexOf("(");
                    s.rank = data.substring(PRANK.length(), sub).trim();
                    sub2 = data.lastIndexOf("XP");
                    s.experience = Integer.parseInt(data.substring(sub + 1, sub2).trim());
                    continue;
                }
                if (data.startsWith("Skills         ")) break;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        this.stat.add(s);
        return true;
    }

    public ArrayList<Statistic> getStats() {
        return this.stat;
    }

    public Statistic getFinalStat() {
        return this.finalStat;
    }

    public static String roundCurrency(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            return String.valueOf(x);
        }
        return df.format(x).replaceAll(",", ".");
    }

    public void calculate() {
        this.finalStat = new Statistic();
        for (Statistic sTemp : this.stat) {
            for (WeaponStatistic wsTemp : sTemp.weaponStats) {
                boolean added = false;
                for (WeaponStatistic fwsTemp : this.finalStat.weaponStats) {
                    if (!fwsTemp.weaponName.equals(wsTemp.weaponName)) continue;
                    added = true;
                    fwsTemp.shots += wsTemp.shots;
                    fwsTemp.hits += wsTemp.hits;
                    fwsTemp.kills += wsTemp.kills;
                    fwsTemp.deaths += wsTemp.deaths;
                    fwsTemp.headshots += wsTemp.headshots;
                    fwsTemp.acc = (double)fwsTemp.hits * 100.0 / (double)fwsTemp.shots;
                    fwsTemp.headAcc = (double)fwsTemp.headshots * 100.0 / (double)fwsTemp.hits;
                    break;
                }
                if (added) continue;
                this.finalStat.weaponStats.add(wsTemp);
            }
        }
        for (Statistic sTemp : this.stat) {
            this.finalStat.rounds += sTemp.rounds;
            this.finalStat.damageGiven += sTemp.damageGiven;
            this.finalStat.damageReceived += sTemp.damageReceived;
            this.finalStat.teamDamageGiven += sTemp.teamDamageGiven;
            this.finalStat.teamDamageReceived += sTemp.teamDamageReceived;
            this.finalStat.gibs += sTemp.gibs;
            this.finalStat.kills += sTemp.kills;
            this.finalStat.deaths += sTemp.deaths;
            this.finalStat.eff = (double)this.finalStat.kills / (double)this.finalStat.deaths;
        }
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static void output(BufferedWriter bw, Statistic stat) throws IOException {
        if (stat.map != null) {
            ETStatistics.writeln(bw, "Map: " + stat.map);
        }
        if (stat.playerName != null) {
            ETStatistics.writeln(bw, "Playername: " + stat.playerName);
        }
        ETStatistics.writeln(bw, "Rounds: " + stat.rounds);
        bw.newLine();
        ETStatistics.writeln(bw, PDMGGIVE + stat.damageGiven);
        ETStatistics.writeln(bw, "Damage Received: " + stat.damageReceived);
        ETStatistics.writeln(bw, "Damage Quote: " + ETStatistics.roundCurrency((double)stat.damageGiven / (double)stat.damageReceived));
        ETStatistics.writeln(bw, "Team Damage Given: " + stat.teamDamageGiven);
        ETStatistics.writeln(bw, PTDMGRECV + stat.teamDamageReceived);
        ETStatistics.writeln(bw, "Team Damage Quote: " + ETStatistics.roundCurrency((double)stat.teamDamageGiven / (double)stat.teamDamageReceived));
        bw.newLine();
        ETStatistics.writeln(bw, "Gibs: " + stat.gibs);
        if (stat.rank != null) {
            ETStatistics.writeln(bw, PRANK + stat.rank);
            ETStatistics.writeln(bw, "XP: " + stat.experience);
        }
        ETStatistics.writeln(bw, "Kills: " + stat.kills);
        ETStatistics.writeln(bw, "Deaths: " + stat.deaths);
        ETStatistics.writeln(bw, "Efficiency: " + ETStatistics.roundCurrency(stat.eff));
        bw.newLine();
        for (WeaponStatistic wStat : stat.weaponStats) {
            ETStatistics.writeln(bw, wStat.weaponName);
            ETStatistics.writeln(bw, "accuracy " + ETStatistics.roundCurrency(wStat.acc) + "%");
            ETStatistics.writeln(bw, "headshotrate " + ETStatistics.roundCurrency(wStat.headAcc) + "%");
            ETStatistics.writeln(bw, "shots / kill " + ETStatistics.roundCurrency((double)wStat.shots / (double)wStat.kills));
            ETStatistics.writeln(bw, "hits / kill " + ETStatistics.roundCurrency((double)wStat.hits / (double)wStat.kills));
            ETStatistics.writeln(bw, "shots " + wStat.shots);
            ETStatistics.writeln(bw, "hits " + wStat.hits);
            ETStatistics.writeln(bw, "kills " + wStat.kills);
            ETStatistics.writeln(bw, "deaths " + wStat.deaths);
            ETStatistics.writeln(bw, "headshots " + wStat.headshots);
            bw.newLine();
        }
        bw.newLine();
        bw.flush();
    }

    private static void output(BufferedWriter bw, ArrayList<Statistic> stats) throws IOException {
        Iterator<Statistic> sIt = stats.iterator();
        while (sIt.hasNext()) {
            ETStatistics.output(bw, sIt.next());
        }
    }

    public void outputStats(BufferedWriter bw) throws IOException {
        ETStatistics.output(bw, this.stat);
    }

    public boolean outputFinalStat(BufferedWriter bw) throws IOException {
        if (this.finalStat != null) {
            ETStatistics.output(bw, this.finalStat);
            return true;
        }
        return false;
    }

    public void outputStats(File f) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        ETStatistics.output(bw, this.stat);
        bw.close();
    }

    public boolean outputFinalStat(File f) throws IOException {
        if (this.finalStat != null) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            ETStatistics.output(bw, this.finalStat);
            bw.close();
            return true;
        }
        return false;
    }
}

