/*
 * Decompiled with CFR 0.152.
 */
package etstatistics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class JVerticalImageList
extends JPanel {
    private Image[] img;
    private Color bgd;
    private int totalHeight;

    public void init(String[] imagePath, Color bgd) throws IOException {
        int i;
        this.bgd = bgd;
        this.img = new Image[imagePath.length];
        for (i = 0; i < imagePath.length; ++i) {
            this.img[i] = ImageIO.read(ClassLoader.getSystemClassLoader().getResource(imagePath[i]));
        }
        this.totalHeight = 0;
        for (i = 0; i < this.img.length; ++i) {
            this.totalHeight += this.img[i].getHeight(this);
        }
    }

    public void paintComponent(Graphics g) {
        int w = (int)this.getPreferredSize().getWidth();
        int h = (int)this.getPreferredSize().getHeight();
        g.setColor(this.bgd);
        g.fillRect(0, 0, w, h);
        if (this.img == null) {
            return;
        }
        int y = (h - this.totalHeight) / 2;
        for (int i = 0; i < this.img.length; ++i) {
            if (this.img[i] == null) continue;
            g.drawImage(this.img[i], (w - this.img[i].getWidth(this)) / 2, y, null);
            y += this.img[i].getHeight(this);
        }
    }
}

