/*
 * Decompiled with CFR 0.152.
 */
package etstatistics;

import etstatistics.ETStatistics;
import etstatistics.JVerticalImageList;
import etstatistics.WeaponStatistic;
import java.awt.Color;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class JWeaponPanel
extends JPanel {
    private static final String PATH = "pics/";
    private static final String[][] WEAPON_IMAGES = new String[][]{{"knife.jpg"}, {"luger.jpg"}, {"colt.jpg"}, {"mp40.jpg"}, {"thompson.jpg"}, {"k43_silenced.jpg", "k43_and_gpg40_granatwerfer.jpg"}, {"mg1_garand_silenced.jpg", "m1_garand_and_m7_grenade_launcher.jpg"}, {"sten.jpg"}, {"fg42.jpg"}, {"axis_grenade.jpg", "allied_grenade.jpg"}, {"k43_and_gpg40_granatwerfer.jpg", "m1_garand_and_m7_grenade_launcher.jpg"}, {"land_mine.jpg"}, {"satchel.jpg"}, {"panzerfaust.jpg"}, {"mortar.jpg"}, {"mg42.jpg"}, {"flamer.jpg"}, {"smoke_grenade.jpg"}, {"binoculars.jpg"}, {"dynamite.jpg"}, {"revive.jpg"}, {"smoke_grenade.jpg"}};
    private JVerticalImageList jImage;
    private JLabel jlAccuracy;
    private JLabel jlDeaths;
    private JLabel jlHeadshotrate;
    private JLabel jlHeadshots;
    private JLabel jlHits;
    private JLabel jlKills;
    private JLabel jlName;
    private JLabel jlShots;

    private String[] getImagePath(String weaponName) {
        for (int i = 0; i < ETStatistics.WEAPON_COUNT; ++i) {
            if (!ETStatistics.getWeapon(i).equalsIgnoreCase(weaponName)) continue;
            return WEAPON_IMAGES[i];
        }
        return null;
    }

    public JWeaponPanel(WeaponStatistic ws) throws IOException {
        this.initComponents();
        this.jImage.init(this.getImagePath(ws.weaponName), Color.WHITE);
        this.jlAccuracy.setText("Accuracy: " + ETStatistics.roundCurrency(ws.acc) + "%");
        this.jlHeadshotrate.setText("Headshotrate: " + ETStatistics.roundCurrency(ws.headAcc) + "%");
        this.jlShots.setText("Shots: " + ws.shots);
        this.jlKills.setText("Kills: " + ws.kills);
        this.jlHits.setText("Hits: " + ws.hits);
        this.jlDeaths.setText("Deaths: " + ws.deaths);
        this.jlHeadshots.setText("Headshots: " + ws.headshots);
        this.jlName.setText(ws.weaponName);
    }

    private void initComponents() {
        this.jlAccuracy = new JLabel();
        this.jlHeadshotrate = new JLabel();
        this.jlShots = new JLabel();
        this.jlKills = new JLabel();
        this.jlHits = new JLabel();
        this.jlDeaths = new JLabel();
        this.jlHeadshots = new JLabel();
        this.jlName = new JLabel();
        this.jImage = new JVerticalImageList();
        this.jlAccuracy.setText("jlAccuracy");
        this.jlHeadshotrate.setText("jlHeadshotrate");
        this.jlShots.setText("jlShots");
        this.jlKills.setText("jlKills");
        this.jlHits.setText("jlHits");
        this.jlDeaths.setText("jlDeaths");
        this.jlHeadshots.setText("jlHeadshots");
        this.jlName.setHorizontalAlignment(0);
        this.jlName.setText("jlName");
        GroupLayout jImageLayout = new GroupLayout(this.jImage);
        this.jImage.setLayout(jImageLayout);
        jImageLayout.setHorizontalGroup(jImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jImageLayout.setVerticalGroup(jImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jlName, -1, -1, Short.MAX_VALUE).addComponent(this.jImage, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlHeadshotrate, -1, 200, Short.MAX_VALUE).addComponent(this.jlAccuracy, -1, 200, Short.MAX_VALUE).addComponent(this.jlShots, -1, 200, Short.MAX_VALUE).addComponent(this.jlHits, -1, 200, Short.MAX_VALUE).addComponent(this.jlKills, -1, 200, Short.MAX_VALUE).addComponent(this.jlDeaths, -1, 200, Short.MAX_VALUE).addComponent(this.jlHeadshots, -1, 200, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jlAccuracy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlHeadshotrate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlShots).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlHits, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlKills, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlDeaths, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlHeadshots, -2, 14, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jImage, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlName))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    static {
        for (int i = 0; i < WEAPON_IMAGES.length; ++i) {
            for (int j = 0; j < WEAPON_IMAGES[i].length; ++j) {
                JWeaponPanel.WEAPON_IMAGES[i][j] = PATH + WEAPON_IMAGES[i][j];
            }
        }
    }
}

