package etstatistics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

/**
 * JVerticalImageList.java
 *
 * Created on 14. February 2010
 * @author Anthales
 */
public class JVerticalImageList extends JPanel {

	private Image img[];
	private Color bgd;
	private int totalHeight;

	public void init(String imagePath[], Color bgd) throws IOException {
		this.bgd = bgd;

		img = new Image[imagePath.length];

		for (int i = 0; i < imagePath.length; i++)
			img[i] = ImageIO.read(
				ClassLoader.getSystemClassLoader().getResource(imagePath[i]));

		totalHeight = 0;
		for (int i = 0; i < img.length; i++)
			totalHeight += img[i].getHeight(this);
	}

	@Override
	public void paintComponent(Graphics g) {
		int w = (int)getPreferredSize().getWidth();
		int h = (int)getPreferredSize().getHeight();

		g.setColor(bgd);
		g.fillRect(0, 0, w, h);

		if (img == null) return;

		int y = (h - totalHeight) / 2;
		for (int i = 0; i < img.length; i++) {
			if (img[i] != null) {
				g.drawImage(img[i], (w - img[i].getWidth(this)) / 2, y, null);
				y += img[i].getHeight(this);
			}
		}
	}
}
