/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;

class Round {
    ArrayList mm1;
    PlayerList players;
    ArrayList eventList;
    PlayerList team1;
    PlayerList team2;
    PlayerList teamunknown;
    Round prevRound;
    Round nextRound;
    Game parentGame;
    short roundType;
    static final short RT_UNKNOWN = 0;
    static final short RT_ROUND1 = 1;
    static final short RT_ROUND2 = 2;
    static final short RT_WARMUP = 3;
    static final short RT_ACTIVE = 4;
    static final short RT_BROKEN = 5;
    static final short RT_DELETED = 6;
    String roundTime;
    String mapname;
    boolean noTeamInformation = false;
    boolean timelimitHit = false;
    int[] statsallobserved = new int[2];
    boolean statsall = false;
    private static Round lastBuiltRound;

    Round() {
        this.mm1 = new ArrayList(100);
        this.players = new PlayerList();
        this.eventList = new ArrayList(1000);
        this.team1 = new PlayerList(10);
        this.team1.side = "allies";
        this.team2 = new PlayerList(10);
        this.team2.side = "axis";
        this.teamunknown = new PlayerList(5);
    }

    public String toString() {
        return " type " + this.roundType + ", map " + this.mapname + ", time " + this.roundTime + ", players " + this.players.size() + ", events " + this.eventList.size() + ", mm1 " + this.mm1.size();
    }

    public PlayerList getAttackingTeam() {
        if (gravyStats.AxisAttackingMap(this.mapname)) {
            return this.team2;
        }
        return this.team1;
    }

    public PlayerList getChasingTeam() {
        if (gravyStats.AxisAttackingMap(this.mapname)) {
            return this.team1;
        }
        return this.team2;
    }

    public boolean createsPlayers() {
        boolean willCreatePlayers = false;
        Iterator i = this.eventList.iterator();
        while (i.hasNext() && !willCreatePlayers) {
            ParsedEvent event = (ParsedEvent)i.next();
            switch (event.eventType) {
                case 2: {
                    willCreatePlayers = true;
                    break;
                }
            }
        }
        return willCreatePlayers;
    }

    public void processActiveRound() {
        if (this.roundType != 4) {
            return;
        }
        boolean found = false;
        Round temp = this.prevRound;
        while (temp != null && !found) {
            if (temp.roundType == 1) {
                if (!this.mapname.equals(temp.mapname)) {
                    this.roundType = 1;
                    gravyStats.debug("Previous active round was round1, but map names arent equal! Setting round1");
                    found = true;
                    break;
                }
                this.roundType = (short)2;
                gravyStats.debug("Previous active round was round1, setting round2");
                found = true;
                break;
            }
            if (temp.roundType == 2) {
                this.roundType = 1;
                gravyStats.debug("Previous active round was round2, setting 1");
                found = true;
                break;
            }
            if (temp.prevRound != null) {
                temp = temp.prevRound;
                continue;
            }
            found = true;
            gravyStats.debug("looking for previous active round to make a guess - not found! assume 1");
            this.roundType = 1;
        }
    }

    public void buildTeams() {
        this.populateTeams();
        if (this.team1.isEmpty() && this.team2.isEmpty()) {
            Player temp;
            this.noTeamInformation = true;
            if (lastBuiltRound != null) {
                temp = (Player)this.teamunknown.get(0);
                gravyStats.debug("***** grabbed " + temp.getName());
                Player prev = Round.lastBuiltRound.players.getPlayer(temp.getName(), 0, false, false);
                if (prev != null) {
                    gravyStats.debug("found in previous round");
                    if (prev.team == 1) {
                        gravyStats.debug("was on team 1");
                        if (this.roundType == 1) {
                            gravyStats.debug("this round is 1, so add player to team1");
                            this.team1.add(temp);
                        } else {
                            gravyStats.debug("this round is 2, so add player to team2");
                            this.team2.add(temp);
                        }
                    } else if (prev.team == 2) {
                        gravyStats.debug("was on team 2");
                        if (this.roundType == 1) {
                            gravyStats.debug("this round is 1, so add player to team2");
                            this.team2.add(temp);
                        } else {
                            gravyStats.debug("this round is 2, so add player to team1");
                            this.team1.add(temp);
                        }
                    } else {
                        gravyStats.debug("previous player had no team :(");
                        this.team1.add(temp);
                        this.teamunknown.remove(temp);
                    }
                } else {
                    gravyStats.debug("not found in previous round");
                    this.team1.add(temp);
                    this.teamunknown.remove(temp);
                }
            } else {
                gravyStats.debug("No team information found! Shoving a random player onto allies");
                temp = (Player)this.teamunknown.get(0);
                this.team1.add(temp);
                this.teamunknown.remove(temp);
                gravyStats.debug("***** grabbed " + temp.getName());
            }
        }
        int unknown_count = this.teamunknown.size();
        while (unknown_count > 0) {
            gravyStats.debug(unknown_count + " players with unknown teams");
            this.findTeamsForUnknowns();
            if (this.teamunknown.size() == unknown_count) {
                gravyStats.debug("none found with " + unknown_count + " remaining");
                break;
            }
            int diff = unknown_count - this.teamunknown.size();
            unknown_count = this.teamunknown.size();
            gravyStats.debug(diff + " found, " + unknown_count + " remaining");
        }
        lastBuiltRound = this;
    }

    private void populateTeams() {
        Iterator i = this.players.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            if (p.team == 1) {
                this.team1.add(p);
                continue;
            }
            if (p.team == 2) {
                this.team2.add(p);
                continue;
            }
            this.teamunknown.add(p);
        }
    }

    private void findTeamsForUnknowns() {
        ArrayList<Player> teamFound = new ArrayList<Player>();
        Iterator i = this.teamunknown.iterator();
        while (i.hasNext()) {
            Player p_test;
            Player p_unknown = (Player)i.next();
            boolean found = false;
            int score = 0;
            Iterator j = this.team1.iterator();
            while (j.hasNext()) {
                p_test = (Player)j.next();
                if (p_test.isTeammate(p_unknown) && !p_test.isEnemy(p_unknown)) {
                    ++score;
                    continue;
                }
                if (!p_test.isEnemy(p_unknown) || p_test.isTeammate(p_unknown)) continue;
                --score;
            }
            j = this.team2.iterator();
            while (j.hasNext()) {
                p_test = (Player)j.next();
                if (p_test.isTeammate(p_unknown) && !p_test.isEnemy(p_unknown)) {
                    --score;
                    continue;
                }
                if (!p_test.isEnemy(p_unknown) || p_test.isTeammate(p_unknown)) continue;
                ++score;
            }
            if (score > 0) {
                this.team1.add(p_unknown);
                p_unknown.team = 1;
                teamFound.add(p_unknown);
                continue;
            }
            if (score < 0) {
                this.team2.add(p_unknown);
                p_unknown.team = 2;
                teamFound.add(p_unknown);
                continue;
            }
            gravyStats.debug("findTeamsForUnknowns: still couldnt find team for " + p_unknown);
        }
        i = teamFound.iterator();
        while (i.hasNext()) {
            this.teamunknown.remove(i.next());
        }
    }
}

