/*
 * Decompiled with CFR 0.152.
 */
public class Game {
    Round round1;
    Round round2;

    public Round getRound1() {
        return this.round1;
    }

    public void setRound1(Round round1) {
        this.round1 = round1;
    }

    public Round getRound2() {
        return this.round2;
    }

    public void setRound2(Round round2) {
        this.round2 = round2;
    }

    public boolean isDraw() {
        if (this.round1 == null || this.round2 == null) {
            return true;
        }
        return !this.round1.isSuccess() && !this.round2.isSuccess();
    }

    public boolean isTeamAWin() {
        if (this.isDraw()) {
            return false;
        }
        if (this.getRound2().isSuccess()) {
            if (Stats.isAlliedOffence(this.getRound2().getMap())) {
                return this.getRound2().getGameNumber() % 2 == 0;
            }
            return this.getRound2().getGameNumber() % 2 != 0;
        }
        if (Stats.isAlliedOffence(this.getRound2().getMap())) {
            return this.getRound2().getGameNumber() % 2 != 0;
        }
        return this.getRound2().getGameNumber() % 2 == 0;
    }

    public boolean isTeamBWin() {
        if (this.isDraw()) {
            return false;
        }
        return !this.isTeamAWin();
    }

    public String getMap() {
        if (this.round1 != null) {
            return this.round1.getMap();
        }
        if (this.round2 != null) {
            return this.round2.getMap();
        }
        return "unknown";
    }

    public int getGameNumber() {
        if (this.round1 != null) {
            return this.round1.getGameNumber();
        }
        if (this.round2 != null) {
            return this.round2.getGameNumber();
        }
        return 0;
    }

    public String getRound1SideTeamA() {
        if (this.round1 != null) {
            return this.round1.getSideTeamA();
        }
        if (this.round2 != null) {
            return this.round2.getSideTeamB();
        }
        return "unknown";
    }

    public boolean isPartial() {
        boolean partial = false;
        if (this.round1 == null || this.round2 == null) {
            return true;
        }
        return this.round1.isPartial() || this.round2.isPartial();
    }
}

