/*
  sorttable.js
  current for version 0.13
  contents last updated with version 0.13
  
  modified version of http://www.kryogenix.org/code/browser/sorttable/
*/

addEvent(window, "load", sortables_init);

var SORT_COLUMN_INDEX;

function sortables_init() {
    // Find all tables with class sortable and make them sortable
    if (!document.getElementsByTagName) return;
    tbls = document.getElementsByTagName("table");
    for (ti=0;ti<tbls.length;ti++) {
        thisTbl = tbls[ti];
		//was based on classname, now based on having 'sortable' in its id.
        if ((thisTbl.id) && ((' '+thisTbl.id+' ').indexOf("sortable") != -1)) {  
            ts_makeSortable(thisTbl);
        }
    }
}


function ts_makeSortable(table) {
	//use the table header rather than the first row
	var tableHeader;
	
	if (table.tHead && table.tHead.rows.length == 1) {
		tableHeader = table.tHead.rows[0];
	}
	if (!tableHeader) return;
    
    for (var i=0;i<tableHeader.cells.length;i++) {
        var cell = tableHeader.cells[i];
        var txt = ts_getInnerText(cell);
		cell.innerHTML = '<div class="sortheader" onclick="ts_resortTable(this);return false;">'+txt+'</div>';		
    }
}

function ts_getInnerText(el) {
	if (typeof el == "string") return el;
	if (typeof el == "undefined") { return el };
	if (el.innerText) return el.innerText;	//Not needed but it is faster
	var str = "";
	
	var cs = el.childNodes;
	var l = cs.length;
	for (var i = 0; i < l; i++) {
		switch (cs[i].nodeType) {
			case 1: //ELEMENT_NODE
				str += ts_getInnerText(cs[i]);
				break;
			case 3:	//TEXT_NODE
				str += cs[i].nodeValue;
				break;
		}
	}
	return str;
}

function ts_resortTable(lnk) {

    var td = lnk.parentNode;
    var column = td.cellIndex;
    var table = getParent(td,'TABLE');
	var tableHeader = table.tHead.rows[0];
    
    // Work out a type for the column
    if (table.rows.length <= 1) return;
    var itm = ts_getInnerText(table.rows[1].cells[column]);
    sortfn = ts_sort_caseinsensitive;
    if (itm.match(/^\d\d[\/-]\d\d[\/-]\d\d\d\d$/)) sortfn = ts_sort_date;
    if (itm.match(/^\d\d[\/-]\d\d[\/-]\d\d$/)) sortfn = ts_sort_date;
    if (itm.match(/^[$]/)) sortfn = ts_sort_currency;
    if (itm.match(/^[\d\.]+$/)) sortfn = ts_sort_numeric;

//bj
    if (itm.match(/^\d+\/\d+$/)) sortfn = ts_sort_rev; //revives, sort by first number

    SORT_COLUMN_INDEX = column;

	var tbodynum;
	//loop through table bodies, sort each independantly
	for (tbodynum = 0; tbodynum < table.tBodies.length; tbodynum++) {
		thisTblBody = table.tBodies[tbodynum];
		
		//doesnt need sorting EG the team summaries
		//Possibly add another check here for style/id if we only want certain tbodys sortable?
		if (thisTblBody.rows.length < 2) {
			continue;
		}
	
    	var firstRow = new Array();
	    var newRows = new Array();
		//this row was broken, fixed
	    for (i=0;i<tableHeader.cells.length;i++) { firstRow[i] = tableHeader.cells[i]; }
    	for (j=0;j<thisTblBody.rows.length;j++) { newRows[j] = thisTblBody.rows[j]; }

	    newRows.sort(sortfn);

		//first click it wont be set to 'down' or 'up'
		//either way if it isnt currently 'down' then it will be - so reverse the sort
	    if (!(lnk.getAttribute("sortdir") == 'down')) {
			newRows.reverse();
	    }
	
	    var alt = "statrow1";
	    for (i=0;i<newRows.length;i++) {
			newRows[i].className = alt; //update the alt styles
			thisTblBody.appendChild(newRows[i]);
			alt = (alt == "statrow1" ? "statrow2" : "statrow1");
		}

		//remove any sort direction flags from other cells
		for (i=0;i<tableHeader.cells.length;i++) {

			thisCell = tableHeader.cells[i];
			thisDiv = thisCell.childNodes[0];
		
			if (i != column) {
				thisDiv.removeAttribute("sortdir");
				thisDiv.className = "sortheader";
			}
		}
	}

	//set the sort direction on this cell
    if (lnk.getAttribute("sortdir") == 'down') {
        lnk.setAttribute('sortdir','up');
		lnk.className = "sortheader_up";
    } else {
        lnk.setAttribute('sortdir','down');
		lnk.className = "sortheader_down";
    }
}

function getParent(el, pTagName) {
	if (el == null) return null;
	else if (el.nodeType == 1 && el.tagName.toLowerCase() == pTagName.toLowerCase())	// Gecko bug, supposed to be uppercase
		return el;
	else
		return getParent(el.parentNode, pTagName);
}
function ts_sort_date(a,b) {
    // y2k notes: two digit years less than 50 are treated as 20XX, greater than 50 are treated as 19XX
    aa = ts_getInnerText(a.cells[SORT_COLUMN_INDEX]);
    bb = ts_getInnerText(b.cells[SORT_COLUMN_INDEX]);
    if (aa.length == 10) {
        dt1 = aa.substr(6,4)+aa.substr(3,2)+aa.substr(0,2);
    } else {
        yr = aa.substr(6,2);
        if (parseInt(yr) < 50) { yr = '20'+yr; } else { yr = '19'+yr; }
        dt1 = yr+aa.substr(3,2)+aa.substr(0,2);
    }
    if (bb.length == 10) {
        dt2 = bb.substr(6,4)+bb.substr(3,2)+bb.substr(0,2);
    } else {
        yr = bb.substr(6,2);
        if (parseInt(yr) < 50) { yr = '20'+yr; } else { yr = '19'+yr; }
        dt2 = yr+bb.substr(3,2)+bb.substr(0,2);
    }
    if (dt1==dt2) return 0;
    if (dt1<dt2) return -1;
    return 1;
}

function ts_sort_currency(a,b) { 
    aa = ts_getInnerText(a.cells[SORT_COLUMN_INDEX]).replace(/[^0-9.]/g,'');
    bb = ts_getInnerText(b.cells[SORT_COLUMN_INDEX]).replace(/[^0-9.]/g,'');
    return parseFloat(aa) - parseFloat(bb);
}

function ts_sort_numeric(a,b) { 
    aa = parseFloat(ts_getInnerText(a.cells[SORT_COLUMN_INDEX]));
    if (isNaN(aa)) aa = 0;
    bb = parseFloat(ts_getInnerText(b.cells[SORT_COLUMN_INDEX])); 
    if (isNaN(bb)) bb = 0;
    return aa-bb;
}

function ts_sort_caseinsensitive(a,b) {
    aa = ts_getInnerText(a.cells[SORT_COLUMN_INDEX]).toLowerCase();
    bb = ts_getInnerText(b.cells[SORT_COLUMN_INDEX]).toLowerCase();
    if (aa==bb) return 0;
    if (aa<bb) return -1;
    return 1;
}

function ts_sort_default(a,b) {
    aa = ts_getInnerText(a.cells[SORT_COLUMN_INDEX]);
    bb = ts_getInnerText(b.cells[SORT_COLUMN_INDEX]);
    if (aa==bb) return 0;
    if (aa<bb) return -1;
    return 1;
}

//bj
function ts_sort_rev(a,b) {
    split_a = ts_getInnerText(a.cells[SORT_COLUMN_INDEX]).split("/");
    split_b = ts_getInnerText(b.cells[SORT_COLUMN_INDEX]).split("/");
    aa = parseFloat(split_a[0]);
    if (isNaN(aa)) aa = 0;
    a2 = parseFloat(split_a[1]);
    if (isNaN(a2)) a2 = 0;
    bb = parseFloat(split_b[0]);
    if (isNaN(bb)) bb = 0;
    b2 = parseFloat(split_b[1]);
    if (isNaN(b2)) b2 = 0;

    if (aa==bb) return b2-a2;  //backwards because less is better
    return aa-bb;
}


function addEvent(elm, evType, fn, useCapture)
// addEvent and removeEvent
// cross-browser event handling for IE5+,  NS6 and Mozilla
// By Scott Andrew
{
  if (elm.addEventListener){
    elm.addEventListener(evType, fn, useCapture);
    return true;
  } else if (elm.attachEvent){
    var r = elm.attachEvent("on"+evType, fn);
    return r;
  } else {
    alert("Handler could not be removed");
	//bj
	return true;
  }
} 
