/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;

public class GameEvent {
    public static String ENTERED = "entered";
    public static String PLAYER = "player";
    public static String ETPRO = "etpro";
    public static String FIGHT = "fight";
    public static String MAP = "map";
    public static String PAUSE = "pause";
    public static String ROUND1 = "round end 1";
    public static String ROUND2 = "round end 2";
    public static String TIMELIMIT = "timelimit hit";
    public static String SHUTDOWN = "shutdown";
    long time = new Date().getTime();
    int lineNumber = Stats.getLineCount();
    String event;
    Player player;
    String line;
    String team;
    String action;
    String objective;

    public GameEvent() {
    }

    public GameEvent(String event, Player player, String line, String team, String action, String objective) {
        this.event = event;
        this.player = player;
        this.line = line;
        this.team = team;
        this.action = action;
        this.objective = objective;
    }

    public GameEvent setEtpro(String version) {
        this.event = ETPRO;
        this.action = version;
        return this;
    }

    public boolean isEtpro() {
        return ETPRO.equals(this.event);
    }

    public String getEtproVersion() {
        return this.action;
    }

    public GameEvent setMap(String name) {
        this.event = MAP;
        this.action = name;
        return this;
    }

    public boolean isMap() {
        return MAP.equals(this.event);
    }

    public String getMap() {
        return this.action;
    }

    public GameEvent setFight() {
        this.event = FIGHT;
        return this;
    }

    public boolean isFight() {
        return FIGHT.equals(this.event);
    }

    public GameEvent setPause(String teamName) {
        this.event = PAUSE;
        this.team = teamName;
        return this;
    }

    public boolean isPause() {
        return PAUSE.equals(this.event);
    }

    public String getPauseTeam() {
        return this.team;
    }

    public GameEvent setEntered(Player player) {
        this.event = PLAYER;
        this.action = ENTERED;
        this.player = player;
        return this;
    }

    public boolean isEntered() {
        return PLAYER.equals(this.event) && ENTERED.equals(this.action);
    }

    public Player getEnteredPlayer() {
        return this.player;
    }

    public GameEvent setShutdown() {
        this.event = SHUTDOWN;
        return this;
    }

    public GameEvent setRoundTimelimitHit() {
        this.event = TIMELIMIT;
        return this;
    }

    public boolean isTimelimitHit() {
        return TIMELIMIT.equals(this.event);
    }

    public GameEvent setRoundOneEnd(String clockTime) {
        this.event = ROUND1;
        this.action = clockTime;
        return this;
    }

    public GameEvent setRoundTwoEnd(boolean success, String clockTime) {
        this.event = ROUND2;
        this.action = clockTime;
        this.objective = success ? "success" : "failure";
        return this;
    }

    public String getRoundClockTime() {
        return this.action;
    }

    public boolean isRoundSuccess() {
        return "success".equals(this.objective) || "".equals(this.objective) || this.objective == null;
    }

    public boolean isRoundEnd() {
        return ROUND1.equals(this.event) || ROUND2.equals(this.event) || SHUTDOWN.equals(this.event);
    }

    public boolean isRoundOneEnd() {
        return ROUND1.equals(this.event);
    }

    public boolean isRoundTwoEnd() {
        return ROUND2.equals(this.event);
    }

    public String getRoundEndTime() {
        return this.action;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getObjective() {
        return this.objective;
    }

    public void setObjective(String objective) {
        this.objective = objective;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

