/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;

public class PlayerRoundStats
implements Comparable {
    Player player;
    boolean estimate;
    int lineNumber = Stats.getLineCount();
    long time;
    String side;
    int kills;
    int deaths;
    int suicides;
    int teamkills;
    int efficiency;
    int gamepoints;
    int gibs;
    int damageGiven;
    int damageReceived;
    int damageTeam;
    int score;
    int killBeforeKilledMax = 0;
    int killBeforeDeathMax = 0;
    int deathBeforeKillMax = 0;
    int killedBeforeKillMax = 0;
    Distribution killBeforeKilled = new Distribution(5);
    Distribution killedBeforeKill = new Distribution(5);
    Distribution weaponKill = new Distribution(4);
    Distribution weaponKilled = new Distribution(4);
    Distribution weaponDetail = new Distribution(32);
    int enteredGameCount;
    long roundStart;
    long lastEntered;
    int slashkills;
    int etproSeen;
    boolean newToRound = false;

    public PlayerRoundStats() {
    }

    public PlayerRoundStats(Player player, String team, String kll, String Dth, String Sui, String TK, String Eff, String GP, String Gibs, String DG, String DR, String TD, String Score) {
        this.time = new Date().getTime();
        this.player = player;
        this.side = team;
        this.kills = new Integer(kll.trim());
        this.deaths = new Integer(Dth.trim());
        this.suicides = new Integer(Sui.trim());
        this.teamkills = new Integer(TK.trim());
        this.efficiency = new Integer(Eff.trim());
        this.gamepoints = new Integer(GP.trim());
        this.gibs = new Integer(Gibs.trim());
        this.damageGiven = new Integer(DG.trim());
        this.damageReceived = new Integer(DR.trim());
        this.damageTeam = new Integer(TD.trim());
        this.score = new Integer(Score.trim());
    }

    public int getDamageGiven() {
        return this.damageGiven;
    }

    public void setDamageGiven(int damageGiven) {
        this.damageGiven = damageGiven;
    }

    public int getDamageReceived() {
        return this.damageReceived;
    }

    public void setDamageReceived(int damageReceived) {
        this.damageReceived = damageReceived;
    }

    public int getDamageTeam() {
        return this.damageTeam;
    }

    public void setDamageTeam(int damageTeam) {
        this.damageTeam = damageTeam;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }

    public int getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(int efficiency) {
        this.efficiency = efficiency;
    }

    public int getGamepoints() {
        return this.gamepoints;
    }

    public void setGamepoints(int gamepoints) {
        this.gamepoints = gamepoints;
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getSuicides() {
        return this.suicides;
    }

    public void setSuicides(int suicides) {
        this.suicides = suicides;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public int getTeamkills() {
        return this.teamkills;
    }

    public void setTeamkills(int teamkills) {
        this.teamkills = teamkills;
    }

    public boolean isEstimate() {
        return this.estimate;
    }

    public void setEstimate(boolean estimate) {
        this.estimate = estimate;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getEnteredGameCount() {
        return this.enteredGameCount;
    }

    public void setEnteredGameCount(int enteredGameCount) {
        this.enteredGameCount = enteredGameCount;
    }

    public long getLastEntered() {
        return this.lastEntered;
    }

    public void setLastEntered(long lastEntered) {
        this.lastEntered = lastEntered;
        ++this.enteredGameCount;
    }

    public long getRoundStart() {
        return this.roundStart;
    }

    public void setRoundStart(long roundStart) {
        this.roundStart = roundStart;
    }

    public int getSlashkills() {
        return this.slashkills;
    }

    public void setSlashkills(int slashkills) {
        this.slashkills = slashkills;
    }

    public boolean isCompleteRound() {
        return this.lastEntered <= this.roundStart;
    }

    public boolean isNewToRound() {
        return this.enteredGameCount != this.etproSeen || this.enteredGameCount == this.etproSeen && !this.isCompleteRound();
    }

    public int getEtproSeen() {
        return this.etproSeen;
    }

    public void setEtproSeen(int etproSeen) {
        this.etproSeen = etproSeen;
    }

    public void show() {
        System.err.println("stats " + this.player.getCleanName() + " k=" + this.kills + ", d=" + this.deaths + ", s=" + this.suicides + ", tk=" + this.teamkills + ", gibs=" + this.gibs + ", eff=" + this.efficiency + ", gp=" + this.gamepoints + ", dg=" + this.damageGiven + ", dr=" + this.damageReceived + ", td=" + this.damageTeam + ", score=" + this.score + ", /kills=" + this.slashkills + ", smgs kills=" + this.getWeaponKill().getIndex(2) + ", sui+/kill=" + (this.suicides + this.slashkills));
    }

    public void calculateEfficiency() {
        this.efficiency = this.deaths + this.suicides == 0 ? this.kills * 100 : this.kills * 100 / (this.deaths + this.suicides);
    }

    public int getGibs() {
        return this.gibs;
    }

    public void setGibs(int gibs) {
        this.gibs = gibs;
    }

    public void sum(PlayerRoundStats prs) {
        this.kills += prs.getKills();
        this.deaths += prs.getDeaths();
        this.suicides += prs.getSuicides();
        this.teamkills += prs.getTeamkills();
        this.slashkills += prs.getSlashkills();
        this.gamepoints += prs.getGamepoints();
        this.gibs += prs.getGibs();
        this.score += prs.getScore();
        this.damageGiven += prs.getDamageGiven();
        this.damageReceived += prs.getDamageReceived();
        this.damageTeam += prs.getDamageTeam();
        this.estimate = this.estimate || prs.isEstimate();
        this.calculateEfficiency();
        this.updateKillBeforeKilledMax(prs.getKillBeforeKilledMax());
        this.updateDeathBeforeKillMax(prs.getDeathBeforeKillMax());
        this.updateKillBeforeDeathMax(prs.getKillBeforeDeathMax());
        this.updateKilledBeforeKillMax(prs.getKilledBeforeKillMax());
        this.killBeforeKilled.sum(prs.getKillBeforeKilled());
        this.killedBeforeKill.sum(prs.getKilledBeforeKill());
        this.weaponKill.sum(prs.getWeaponKill());
        this.weaponKilled.sum(prs.getWeaponKilled());
        this.weaponDetail.sum(prs.getWeaponDetail());
    }

    public void combine(PlayerRoundStats prs) {
        this.kills = prs.getKills();
        this.deaths = prs.getDeaths();
        this.suicides = prs.getSuicides();
        this.teamkills = prs.getTeamkills();
        this.slashkills = prs.getSlashkills();
        this.estimate = this.estimate || prs.isEstimate();
        this.calculateEfficiency();
        this.updateKillBeforeKilledMax(prs.getKillBeforeKilledMax());
        this.updateDeathBeforeKillMax(prs.getDeathBeforeKillMax());
        this.updateKillBeforeDeathMax(prs.getKillBeforeDeathMax());
        this.updateKilledBeforeKillMax(prs.getKilledBeforeKillMax());
        this.killBeforeKilled.overwrite(prs.getKillBeforeKilled());
        this.killedBeforeKill.overwrite(prs.getKilledBeforeKill());
        this.weaponKill.overwrite(prs.getWeaponKill());
        this.weaponKilled.overwrite(prs.getWeaponKilled());
        this.weaponDetail.overwrite(prs.getWeaponDetail());
    }

    public int getKilledBeforeKillMax() {
        return this.killedBeforeKillMax;
    }

    public void setKilledBeforeKillMax(int killedBeforeKillMax) {
        this.killedBeforeKillMax = killedBeforeKillMax;
    }

    public void updateKilledBeforeKillMax(int killedBeforeKill) {
        this.killedBeforeKillMax = Math.max(this.killedBeforeKillMax, killedBeforeKill);
    }

    public int getDeathBeforeKillMax() {
        return this.deathBeforeKillMax;
    }

    public void setDeathBeforeKillMax(int deathBeforeKillMax) {
        this.deathBeforeKillMax = deathBeforeKillMax;
    }

    public void updateDeathBeforeKillMax(int deathBeforeKill) {
        this.deathBeforeKillMax = Math.max(this.deathBeforeKillMax, deathBeforeKill);
    }

    public int getKillBeforeDeathMax() {
        return this.killBeforeDeathMax;
    }

    public void setKillBeforeDeathMax(int killBeforeDeathMax) {
        this.killBeforeDeathMax = killBeforeDeathMax;
    }

    public void updateKillBeforeDeathMax(int killBeforeDeath) {
        this.killBeforeDeathMax = Math.max(this.killBeforeDeathMax, killBeforeDeath);
    }

    public int getKillBeforeKilledMax() {
        return this.killBeforeKilledMax;
    }

    public void setKillBeforeKilledMax(int killBeforeKilledMax) {
        this.killBeforeKilledMax = killBeforeKilledMax;
    }

    public void updateKillBeforeKilledMax(int killBeforeKilled) {
        this.killBeforeKilledMax = Math.max(this.killBeforeKilledMax, killBeforeKilled);
    }

    public Distribution getKillBeforeKilled() {
        return this.killBeforeKilled;
    }

    public Distribution getKilledBeforeKill() {
        return this.killedBeforeKill;
    }

    public Distribution getWeaponKill() {
        return this.weaponKill;
    }

    public Distribution getWeaponKilled() {
        return this.weaponKilled;
    }

    public int getPercentOfKills(int value) {
        return this.getPercentOfTotal(value, this.kills);
    }

    public int getPercentOfDeaths(int value) {
        return this.getPercentOfTotal(value, this.deaths);
    }

    public int getPercentOfTotal(int value, int total) {
        return total > 0 ? (int)Math.round((double)value / (double)total * 100.0) : 0;
    }

    public int compareTo(Object o) {
        PlayerRoundStats player = (PlayerRoundStats)o;
        if (this.score == player.getScore()) {
            return 0;
        }
        if (this.score > player.getScore()) {
            return 1;
        }
        return -1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public Distribution getWeaponDetail() {
        return this.weaponDetail;
    }
}

