/*
 * Decompiled with CFR 0.152.
 */
import java.util.Comparator;

class PlayerComparator
implements Comparator {
    static final int SORT_DAMAGE_GIVEN = 1;
    static final int SORT_DAMAGE_RECEIVED = 2;
    static final int SORT_DAMAGE_RATIO = 3;
    static final int SORT_TEAM_DAMAGE = 4;
    static final int SORT_KILLS = 11;
    static final int SORT_DEATHS = 12;
    static final int SORT_SUICIDES = 13;
    static final int SORT_SLASH_KILLS = 14;
    static final int SORT_EFFICIENCY = 15;
    static final int SORT_KNIFE_KILLS = 21;
    static final int SORT_KNIFE_DEATHS = 22;
    static final int SORT_GIBS = 23;
    static final int SORT_GIBS_PER_KILL = 24;
    static final int SORT_REVIVES = 35;
    static final int SORT_DAMAGE_RECEIVED_PER_DEATH = 25;
    static final int SORT_DAMAGE_GIVEN_PER_KILL = 26;
    static final int SORT_KILL_STREAK = 27;
    static final int SORT_DEATH_STREAK = 28;
    static final int SORT_MM1 = 29;
    static int sort_type = 1;
    static boolean sortDescending = true;
    Player p1;
    Player p2;
    int int1;
    int int2;
    float float1;
    float float2;

    PlayerComparator() {
    }

    public void setSortType(int type) {
        sortDescending = true;
        sort_type = type;
    }

    public void setSortType(int type, boolean sortDesc) {
        sortDescending = sortDesc;
        sort_type = type;
    }

    public int compare(Object o1, Object o2) {
        this.p1 = (Player)o1;
        this.p2 = (Player)o2;
        switch (sort_type) {
            case 1: {
                this.int1 = this.p1.stats.damageGiven;
                this.int2 = this.p2.stats.damageGiven;
                return this.compareInt();
            }
            case 2: {
                this.int1 = this.p1.stats.damageReceived;
                this.int2 = this.p2.stats.damageReceived;
                return this.compareInt();
            }
            case 3: {
                this.float1 = this.p1.stats.dmg_efficiency;
                this.float2 = this.p2.stats.dmg_efficiency;
                return this.compareFloat();
            }
            case 4: {
                this.int1 = this.p1.stats.teamDamage;
                this.int2 = this.p2.stats.teamDamage;
                return this.compareInt();
            }
            case 11: {
                this.int1 = this.p1.stats.kills;
                this.int2 = this.p2.stats.kills;
                return this.compareInt();
            }
            case 12: {
                this.int1 = this.p1.stats.deaths;
                this.int2 = this.p2.stats.deaths;
                return this.compareInt();
            }
            case 13: {
                this.int1 = this.p1.stats.suicides;
                this.int2 = this.p2.stats.suicides;
                return this.compareInt();
            }
            case 14: {
                this.int1 = this.p1.stats.slashkills;
                this.int2 = this.p2.stats.slashkills;
                return this.compareInt();
            }
            case 15: {
                this.float1 = this.p1.stats.efficiency;
                this.float2 = this.p2.stats.efficiency;
                return this.compareFloat();
            }
            case 21: {
                this.int1 = this.p1.stats.getWeaponStat(0, 0);
                this.int2 = this.p2.stats.getWeaponStat(0, 0);
                return this.compareInt();
            }
            case 22: {
                this.int1 = this.p1.stats.getWeaponStat(1, 0);
                this.int2 = this.p2.stats.getWeaponStat(1, 0);
                return this.compareInt();
            }
            case 23: {
                this.int1 = this.p1.stats.gibs;
                this.int2 = this.p2.stats.gibs;
                return this.compareInt();
            }
            case 24: {
                this.float1 = this.p1.stats.gibsPerKill;
                this.float2 = this.p2.stats.gibsPerKill;
                return this.compareFloat();
            }
            case 35: {
                this.int1 = this.p1.stats.revives;
                this.int2 = this.p2.stats.revives;
                return this.compareInt();
            }
            case 25: {
                this.int1 = this.p1.stats.damagePerDeath;
                this.int2 = this.p2.stats.damagePerDeath;
                return this.compareInt();
            }
            case 26: {
                this.int1 = this.p1.stats.damagePerKill;
                this.int2 = this.p2.stats.damagePerKill;
                return this.compareInt();
            }
            case 27: {
                this.int1 = this.p1.stats.maxkillstreak;
                this.int2 = this.p2.stats.maxkillstreak;
                return this.compareInt();
            }
            case 28: {
                this.int1 = this.p1.stats.maxdeathstreak;
                this.int2 = this.p2.stats.maxdeathstreak;
                return this.compareInt();
            }
            case 29: {
                this.int1 = this.p1.stats.mm1count;
                this.int2 = this.p2.stats.mm1count;
                return this.compareInt();
            }
        }
        return 0;
    }

    public int compareInt() {
        if (this.int1 == this.int2) {
            return 0;
        }
        if (this.int1 < this.int2) {
            if (sortDescending) {
                return 1;
            }
            return -1;
        }
        if (this.int2 < this.int1) {
            if (sortDescending) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int compareFloat() {
        if (this.float1 == this.float2) {
            return 0;
        }
        if (this.float1 < this.float2) {
            if (sortDescending) {
                return 1;
            }
            return -1;
        }
        if (this.float2 < this.float1) {
            if (sortDescending) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

